function pad (num, size) {
    num = num.toString();
    while (num.length < size) num = "0" + num;
    return num;
}

function clamp (lo, hi, val) {
    if (val < lo) return lo;
    if (val > hi) return hi;
    return val;
}

function zeroedArray (num) {
    var arr = new Array();
    for (var i = 0; i < num; i++) {
        arr.push(0);
    }
    return arr;
}

function falseArray (num) {
    var arr = new Array();
    for (var i = 0; i < num; i++) {
        arr.push(0);
    }
    return arr;
}

function zeroed2DArray (x,y) {
    var arr = new Array();
    for (var i = 0; i < x; i++) {
        arr.push(zeroedArray(y));
    }
    return arr;
}

function zeroed3DArray (x,y,z)
{
    var arr = new Array();
    for (var i = 0; i < x; i++) {
        arr.push(zeroed2DArray(y,z));
    }
    return arr;
}

function dataOut (msg) {
    var hex = new Array();
    for (var i = 0; i < msg.length; i++) {
        hex.push(msg[i].toString(16));
    }
    logMsg ("<<<", hex);
}

function repeatedString (strIn, times) {
    var str = "";
    for (var i = 0; i < times; i++) {
        str + strIn;
    }
    return strIn;
}

function strToArray (str) {
    var a = [];
    for (var i = 0; i < str.length; i++) {
        a.push(str.charCodeAt (i));
    }
    return a;
}

function paddedRight (str, len) {
    while (str.length < len) {
        str = str + " ";
    }
    return str;
}

function isString (obj) {
    return (Object.prototype.toString.call(obj) === '[object String]');
}

function volumeFaderPositionToDB (pos) {
    return (pos > 0.0) ? (20 * Math.log (pos)) + 6.0 : -100.0;
}

function decibelsToString (db) {
    if (db < -96.0) return "-INF";

    return db.toFixed(1);
}

function decibelsToStringWithUnit (db) {
    if (db < -96.0) return "-INF";

    return db.toFixed(1) + "dB";
}

function panToString (val) {

    if (val == 0) return "C"

    return (val * 100).toFixed(0) + "%" + (val < 0 ? " L" : " R");
}


// TODO
// track colors ... not possible for now?
// separate EQ from plugins? ... not possible for now?
// switch through banks by clicking FX EQ SEND again ... not possible for now because only back and forth?
// master mute doesn't exist?
// only light up encoders that have markers in marker mode?


// Logging
// Files C:\Users\xxxxx\AppData\Roaming\Tracktion\Waveform\Temporary
// Files C:\Users\xxxxx\AppData\Roaming\Tracktion\Waveform\Controllers\Factory
// logMsg (data, ...)


function AsparionD700() 
{
    this.deviceDescription                  = "Asparion D700";
    this.midiChannelName                    = "D 700";                // MIDI channel name
    this.midiBackChannelName                = "D 700";                // MIDI channel name
    this.needsMidiBackChannel               = true;
    this.wantsClock                         = false;
    this.numberOfFaderChannels              = 8;
    this.numberOfFaderChannelsPerDev        = 8;
    this.numCharactersForTrackNames         = 12;
    this.numCharactersForAuxLabels          = 12;
    this.numCharactersForParameterLabels    = 12;
    this.numParameterControls               = 8;
    this.numMarkers                         = 8;
    this.numCharactersForMarkerLabels       = 12;
    this.shiftKeysDown                      = 0;
    this.wantsAuxBanks                      = true;
    this.needsMidiChannel                   = true;
    this.supportedExtenders                 = 7; 

    this.maxNumSurfaces                     = 8;
    this.maxNumChannels                     = this.maxNumSurfaces * 8;
    this.maxCharsOnDisplay                  = 192;
    this.maxCharsOnDisplayThird             = 64;
    this.maxCharsOnDisplayPerLine           = 96;
    this.maxCharsOnDisplayPerLineThird      = 64;
    this.maxCharsOnDisplayPerDisplay        = 12;
    this.maxCharsOnDisplayPerDisplayThird   = 8;

    this.mcuIdx                             = 0;        // position of the main unit
    this.oneTouchRecord                     = true;     // does record need play + record or just record
    this.numExtenders                       = 0;        // number of Extensions connected

    this.assignmentMode                     = "TrackMode";
    this.panPos                             = zeroedArray(this.maxNumChannels);

    this.lastChannelLevelsR                 = zeroedArray(this.maxNumChannels);
    this.lastChannelLevelsL                 = zeroedArray(this.maxNumChannels);
    this.recLight                           = falseArray(this.maxNumChannels);
    this.isRecButtonDown                    = false;
    this.flipped                            = false;
    this.shiftKeysDown                      = 0;
    this.currentDisplayChars                = zeroed3DArray(3, this.maxNumSurfaces, this.maxCharsOnDisplayPerLine);
    this.newDisplayChars                    = zeroed3DArray(3, this.maxNumSurfaces, this.maxCharsOnDisplayPerLine);
    this.currentChannelNos                  = zeroed2DArray(this.maxNumSurfaces, this.numberOfFaderChannelsPerDev);
    this.newChannelNos                      = zeroed2DArray(this.maxNumSurfaces, this.numberOfFaderChannelsPerDev);
    this.lastRewindPress                    = 0;
    this.lastFaderPos                       = zeroed2DArray(this.maxNumSurfaces, 9);
    this.auxLevels                          = zeroedArray(this.maxNumChannels);
    this.auxBusNames                        = zeroed2DArray(this.maxNumChannels, this.maxCharsOnDisplayPerDisplay);
    this.auxBank                            = 0;
    this.userMovedAuxes                     = new Array();

    this.initialise = function() 
    {
        this.indicesChanged();
    }

    this.indicesChanged = function()
    {
        for (var i = 0; i < this.maxNumSurfaces; ++i)
            for (var j = 9; --j >= 0;)
                this.lastFaderPos[i][j] = 0x7fffffff;

        this.panPos                         = zeroedArray(this.maxNumChannels);
        this.lastChannelLevelsR             = zeroedArray(this.maxNumChannels);
        this.lastChannelLevelsL             = zeroedArray(this.maxNumChannels);
        this.recLight                       = falseArray(this.maxNumChannels);
        this.currentDisplayChars            = zeroed3DArray(3, this.maxNumSurfaces, this.maxCharsOnDisplayPerLine);
        this.newDisplayChars                = zeroed3DArray(3, this.maxNumSurfaces, this.maxCharsOnDisplayPerLine);
    }

    this.setDisplay = function(devIdx, text, row, pos)
    {       
        var maxChars = this.maxCharsOnDisplayPerLine;

        if (row == 2)
            maxChars = this.maxCharsOnDisplayPerLineThird
           
        var len = Math.min(maxChars - pos, text.length);

        for (var i = 0; i < len; i++)
            this.newDisplayChars[row][devIdx][pos + i] = text[i];

        triggerAsyncUpdate();
    }

    this.setWholeDisplay = function(devIdx, topLine, bottomLine, thirdLine)
    {
        if (isString(topLine))    
            topLine = strToArray(topLine);
        if (isString(bottomLine)) 
            bottomLine = strToArray(bottomLine);
        if (isString(thirdLine)) 
            thirdLine = strToArray(thirdLine);

        for (var i = 0; i < this.maxCharsOnDisplayPerLine; i++)
        {
            this.newDisplayChars[0][devIdx][i] = 0;
            this.newDisplayChars[1][devIdx][i] = 0;
        }

        for (var i = 0; i < this.maxCharsOnDisplayPerLineThird; i++)
            this.newDisplayChars[2][devIdx][i] = 0;

        for (var i = 0; i < Math.min(this.maxCharsOnDisplayPerLine, topLine.length); i++) 
            this.newDisplayChars[0][devIdx][i] = topLine[i];
        for (var i = 0; i < Math.min(this.maxCharsOnDisplayPerLine, bottomLine.length); i++) 
            this.newDisplayChars[1][devIdx][i] = bottomLine[i];
        for (var i = 0; i < Math.min(this.maxCharsOnDisplayPerDisplayThird, thirdLine.length); i++) 
            this.newDisplayChars[2][devIdx][i] = thirdLine[i];

        triggerAsyncUpdate();
    }

    this.clearDisplaySegment = function(devIdx, column, row)
    {
        this.setDisplaySegment(devIdx, column, row, repeatedString(" ", this.maxCharsOnDisplayPerDisplay));
    }

    this.setDisplaySegment = function(devIdx, column, row, text)
    {
        if (row == 2)
        {
            var str = text.substring(0, this.maxCharsOnDisplayPerDisplayThird);
            str = paddedRight(str, this.maxCharsOnDisplayPerDisplayThird);

            this.setDisplay(devIdx, strToArray(str), row, column * this.maxCharsOnDisplayPerDisplayThird);
        }
        else
        {
            var str = text.substring(0, this.maxCharsOnDisplayPerDisplay);
            str = paddedRight(str, this.maxCharsOnDisplayPerDisplay);

            this.setDisplay(devIdx, strToArray(str), row, column * this.maxCharsOnDisplayPerDisplay);
        }
    }

    this.onAsyncUpdateSingleLine = function(line)
    {
        var lineLength = this.maxCharsOnDisplayPerLine;

        if (line == 2)
            lineLength = this.maxCharsOnDisplayPerLineThird;

        for (var i = 0; i < this.numExtenders + 1; ++i)
        {
            var newChars = zeroedArray(lineLength);
            
            for (var j = 0; j < lineLength; ++j)
                newChars[j] = this.newDisplayChars[line][i][j];

            var currentChars = this.currentDisplayChars[line][i];

            for (var j = 0; j < lineLength; ++j)
                if (newChars[j] == 0)
                    newChars[j] = 32;

            var end = lineLength - 1;
          
            while (end > 0)
            {
                if (newChars[end] != currentChars[end])
                {
                    ++end;
                    break;
                }

                --end;
            }

            var start = 0;

            while (start < end)
            {
                if (newChars[start] != currentChars[start])
                    break;

                ++start;
            }

            if (end > start)
            {
                var d = new Array();
                d.push(0xf0);
                d.push(0x00);
                d.push(0x00);
                d.push(0x66);
                d.push(i == this.mcuIdx ? 0x14 : 0x15);

                if (line == 2)
                {
                    d.push(0x19);
                    d.push(start); 
                }
                else
                {
                    d.push(0x1A);
                    d.push(start); 
                    d.push(line + 1);
                }

                for (var j = 0; j < (end - start); ++j)
                    d.push(newChars[start + j]);

                d.push(0xf7)

                sendMidiToDevice(d, i);

                for (var j = 0; j < lineLength; j++)
                    this.currentDisplayChars[line][i][j] = newChars[j];
            }
        }
    }

    this.onAsyncUpdate = function()
    {       
        this.onAsyncUpdateSingleLine(0);
        this.onAsyncUpdateSingleLine(1);
        this.onAsyncUpdateSingleLine(2);
 
        // Update channel nos
        for (var i = 0; i < this.numExtenders + 1; ++i)
        {
            var foundChange = false;

            for (var j = 0; j < this.numberOfFaderChannelsPerDev; ++j)
            {
                if (this.currentChannelNos[i][j] != this.newChannelNos[i][j])
                {
                    this.currentChannelNos[i][j] = this.newChannelNos[i][j];
                    foundChange = true;
                }
            }     

            if (!foundChange)
                continue;

            var d = zeroedArray(7 + this.numberOfFaderChannelsPerDev + 1);
            d[0] = 0xf0;
            d[3] = 0x66;
            d[4] = (i == this.mcuIdx ? 0x14 : 0x15);
            d[5] = 0x17;
            d[6] = 0; // start
            d[7 + this.numberOfFaderChannelsPerDev] = 0xf7;

            for (var j = 0; j < this.numberOfFaderChannelsPerDev; ++j)
                d[7 + j] = this.currentChannelNos[i][j];

            sendMidiToDevice(d, i);
        }

    }

    this.initialiseDevice = function()
    {
        this.isRecButtonDown = 0;

        this.indicesChanged();

        this.auxLevels   = zeroedArray(this.maxNumChannels);
        this.auxBusNames = zeroed2DArray(this.maxNumChannels, this.maxCharsOnDisplayPerDisplay);

        for (var i = 0; i < 0x20; ++i)
            this.lightUpButton(this.mcuIdx, i, false);

        this.currentDisplayChars                = zeroed3DArray(3, this.maxNumSurfaces, this.maxCharsOnDisplay);
        this.newDisplayChars                 = zeroed3DArray(3, this.maxNumSurfaces, this.maxCharsOnDisplay);
    
        for (var i = 0; i < this.numExtenders + 1; i++)
            this.setWholeDisplay(i, "                - Tracktion Waveform -    ", "", "");

        sleep(100);

        this.assignmentMode = "PluginMode";
        this.setAssignmentMode("TrackMode");

        this.flipped = true;
        this.flip();

        this.updateMiscFeatures();
    }

    this.shutDownDevice = function()
    {
        // send a reset message:
        var d = [ 0xf0, 0x00, 0x00, 0x66, 0x14, 0x63, 0x00, 0xf7 ];
        sendMidiToDevice(d, this.mcuIdx);
    }

    this.updateMiscFeatures = function()
    {
        this.lightUpButton(this.mcuIdx, 0x58, getIsPlayInStop());       
        this.lightUpButton(this.mcuIdx, 0x4a, getBigInputMetersMode());
    }

    this.onMidiReceivedFromDevice = function(d, deviceIndex)
    {
        var d1 = d[1];

        if (d[0] == 0xb0)
        {
            if (d[1] >= 0x10 && d[1] <= 0x17)
            {
                var chan = (d[1] & 0x0f) + 8 * deviceIndex;
                var diff = 0.02 * (d[2] & 0x0f);

                if ((d[2] & 0x40) != 0)
                    diff = -diff;

                this.panPos[chan] = clamp(-1.0, 1.0, this.panPos[chan] + diff);

                if (this.flipped)
                {
                    setFader(chan, (this.panPos[chan] + 1.0) * 0.5, false);
                }
                else
                {
                    if (this.assignmentMode == "PluginMode")
                    {
                        setParameter(chan, (this.panPos[chan] + 1.0) * 0.5);
                    }
                    else if (this.assignmentMode == "AuxMode")
                    {
                        setAux(chan, (this.panPos[chan] + 1.0) * 0.5);
                        if (this.userMovedAuxes.indexOf(chan) < 0)
                            this.userMovedAuxes.push(chan);
                        startTimer("auxTimer", 2000);
                    }
                    else if (this.assignmentMode == "PanMode" || this.assignmentMode == "TrackMode")
                    {
                        setPanPot(chan, this.panPos[chan], false);
                    }
                }
            }
        }
        else if (d[0] >= 0xe0 && d[0] <= 0xe8)
        {
            // fader
            var pos = clamp(0.0, 1.0, (((d[2]) << 7) + d[1]) * (1.0 / 0x3f70));

            if (d[0] == 0xe8)
            {
                setMasterLevelFader(pos);
            }
            else
            {
                if (this.flipped)
                {
                    if (this.assignmentMode == "PluginMode")
                    {
                        userMovedParameterControl((d[0] & 0x0f) + deviceIndex * 8, pos);
                    }
                    else if (this.assignmentMode == "AuxMode")
                    {
                        userMovedAux((d[0] & 0x0f) + deviceIndex * 8, pos);
                        var v = (d[0] & 0x0f) + deviceIndex * 8;
                        if (this.userMovedAuxes.indexOf(v) < 0)
                            this.userMovedAuxes.push(v);
                        startTimer("auxTimer", 2000);
                    }
                    else if (this.assignmentMode == "PanMode" || this.assignmentMode == "TrackMode")
                    {
                        setPanPot((d[0] & 0x0f) + deviceIndex * 8, pos * 2.0 - 1.0, false);
                    }
                }
                else
                {
                    setFader((d[0] & 0x0f) + deviceIndex * 8, pos, false);
                }
            }
        }
        else if (d[0] == 0x90)
        {
            if (d1 == 0x5f)
            {
                this.isRecButtonDown = (d[2] != 0);

                if (this.oneTouchRecord)
                {
                    if (this.isRecButtonDown)
                    {
                        if (this.shiftKeysDown != 0)
                            armAll();
                        else
                            record();
                    }
                }
                else
                {
                    if (this.isRecButtonDown && (this.shiftKeysDown != 0))
                        armAll();
                }
            }
            else if (d[2] != 0)
            {
                if (d1 >= 0x08 && d1 <= 0x0f) // solo
                {
                    if (this.shiftKeysDown)
                        toggleSoloIsolate((d1 - 0x08) + 8 * deviceIndex);
                    else
                        toggleSolo((d1 - 0x08) + 8 * deviceIndex);
                }
                else if (d1 >= 0x10 && d1 <= 0x17) // mute
                {
                    toggleMute((d1 - 0x10) + 8 * deviceIndex, this.shiftKeysDown != 0);
                }
                else if (d1 >= 0x20 && d1 <= 0x27)
                {
                    var chan = (d1 & 0x0f) + 8 * deviceIndex;
                    this.panPos[chan] = 0.0;

                    if (this.flipped)
                    {
                        setFader(chan, decibelsToVolumeFaderPosition(0.0), false);
                    }
                    else
                    {
                        if (this.assignmentMode == "PluginMode")
                        {
                            incrementParameter(chan);
                        }
                        else if (this.assignmentMode == "AuxMode")
                        {
                            toggleAuxMute(chan);
                        }
                        else if (this.assignmentMode == "MarkerMode")
                        {
                            goToMarker(chan);
                        }
                        else if (this.assignmentMode == "PanMode" || this.assignmentMode == "TrackMode")
                        {
                            setPanPot(chan, 0.0, false);
                        }
                    }
                }
                else if (d1 >= 0x18 && d1 <= 0x1f) // select
                {
                    selectTrack((d1 - 0x18) + 8 * deviceIndex);
                }
                else if (d1 <= 0x07) // rec
                {
                    toggleRecEnable(d1 + 8 * deviceIndex, this.shiftKeysDown != 0);
                }
                else if (d1 == 0x5d)
                {
                    stop();
                }
                else if (d1 == 0x5e)
                {
                    if (this.oneTouchRecord)
                    {
                        play();
                    }
                    else
                    {
                        if (this.isRecButtonDown)
                            record();
                        else
                            play();
                    }
                }
                // else if (d1 == 0x30)
                // {
                //     changeFaderBanks(-1);
                // }
                // else if (d1 == 0x31)
                // {
                //     changeFaderBanks(1);
                // }
                else if (d1 == 0x36) // F1 usw bis F8 3D
                {
                    toggleMixerWindow(false);
                }
                else if (d1 == 0x37)
                {
                    toggleMasterEnable();
                }
                else if (d1 == 0x38)
                {
                    if (this.shiftKeysDown)
                        jumpToMarkIn();
                    else
                        setMarkIn();
                }
                else if (d1 == 0x39)
                {
                    if (this.shiftKeysDown)
                        jumpToMarkOut();
                    else
                        setMarkOut();
                }
                else if (d1 == 0x3a)
                {
                    cut();
                }
                else if (d1 == 0x3b)
                {
                    copy();
                }
                else if (d1 == 0x3c)
                {
                    paste (this.shiftKeysDown != 0);
                }
                else if (d1 == 0x3d)
                {
                    del (this.shiftKeysDown != 0);
                }
                else if (d1 == 0x40)
                {
                    gotoPreviousMarker();
                }
                else if (d1 == 0x41)
                {
                    gotoNextMarker();
                } 
                else if (d1 == 0x43)
                {
                    showProjectScreen();
                }
                else if (d1 == 0x44)
                {
                    showSettingsScreen();
                }
                else if (d1 == 0x45)
                {
                    showEditScreen();
                }
                else if (d1 == 0x56)
                {
                    toggleLoop();
                }
                else if (d1 == 0x59)
                {
                    toggleClick();
                }
                else if (d1 == 0x57)
                {
                    toggleSnap();
                }
                else if (d1 == 0x58)
                {
                    togglePlayInStop();
                }
                else if (d1 == 0x5a)
                {
                    if (this.shiftKeysDown)
                        toggleVideoWindow();
                    else
                        toggleSlave();
                }
                else if (d1 == 0x60)
                {                    
                    scrollTracksDown();
                }
                else if (d1 == 0x61)
                {
                    scrollTracksUp();
                }
                else if (d1 == 0x62)
                {
                    scrollTracksLeft();
                }
                else if (d1 == 0x63)
                {
                    scrollTracksRight();
                }
                else if (d1 == 0x2A)
                {
                    this.setAssignmentMode("PanMode");
                }
                else if (d1 == 0x29)
                {
                    this.setAssignmentMode("AuxMode");
                }
                else if (d1 == 0x2B)
                {
                    this.setAssignmentMode("PluginMode");
                }
                else if (d1 == 0x2C)
                {
                    this.setAssignmentMode("MarkerMode");
                }
                else if (d1 == 0x2e)
                {
                    changeFaderBanks(-(this.numExtenders + 1) * 8);
                }
                else if (d1 == 0x2f)
                {
                    changeFaderBanks((this.numExtenders + 1) * 8);
                }
                else if (d1 == 0x30)
                {
                    if (this.assignmentMode == "PluginMode")
                    {
                        changeParameterBank(-(this.numExtenders + 1) * 8);
                    }
                    else if (this.assignmentMode == "MarkerMode")
                    {
                        changeMarkerBank(-(this.numExtenders + 1) * 8);
                    }
                    else if (this.assignmentMode == "AuxMode")
                    {
                        changeAuxBank(-1);
                        changeFaderBanks(0);
                    }
                }
                else if (d1 == 0x31)
                {
                    if (this.assignmentMode == "PluginMode")
                    {
                        changeParameterBank((this.numExtenders + 1) * 8);
                    }
                    else if (this.assignmentMode == "MarkerMode")
                    {
                        changeMarkerBank((this.numExtenders + 1) * 8);
                    }
                    else if (this.assignmentMode == "AuxMode")
                    {
                        changeAuxBank(+1);
                        changeFaderBanks(0);
                    }
                }
                else if (d1 == 0x32)
                {
                    this.flip();
                }
                else if (d1 == 0x66)
                {
                    footSwitch1();
                }
                else if (d1 == 0x2E)
                {
                    footSwitch2();
                }
            }
        }
        else if (d[0] == 0xf0)
        {
            if (d[1] == 0
                && d[2] == 0
                && d[3] == 0x66
                && d[4] == 0x14
                && d[5] == 0x01)
            {
                // device ready message..
                if (deviceIndex == this.mcuIdx)
                {
                    this.initialiseDevice();
                    updateDeviceState();
                }
            }
        }
    }

    this.flip = function()
    {
        this.flipped = ! this.flipped;
        this.lightUpButton(this.mcuIdx, 0x32, this.flipped);
        updateDeviceState();
    }

    this.setAllDisplaySegments = function(newText)
    {
        for (var i = 0; i < this.numExtenders + 1; i++)
            for (var j = 0; j < this.numberOfFaderChannelsPerDev; j++)
                this.setDisplaySegment(i, j, 2, newText);
    }

    this.setAssignmentMode = function(newMode)
    {
        if (this.assignmentMode != newMode)
        {
            stopTimer("auxTimer");
            this.auxBusNames = zeroed2DArray(this.maxNumChannels, this.maxCharsOnDisplayPerDisplay);
            this.userMovedAuxes = new Array();

            this.assignmentMode = newMode;
            redrawSelectedPlugin();

            this.lightUpButton(this.mcuIdx, 0x2A, this.assignmentMode == "PanMode");
            this.lightUpButton(this.mcuIdx, 0x29, this.assignmentMode == "AuxMode");
            this.lightUpButton(this.mcuIdx, 0x2B, this.assignmentMode == "PluginMode");
            this.lightUpButton(this.mcuIdx, 0x2C, this.assignmentMode == "MarkerMode");

            this.clearAllDisplays();

            if (newMode == "PluginMode")
            {
                this.setAllDisplaySegments("FX");
                changeParameterBank(0);
                changeFaderBanks(0);
            }
            else if (newMode == "PanMode")
            {
                this.setAllDisplaySegments("Pan"); 
                changeFaderBanks(0);
            }
            else if (newMode == "AuxMode")
            {
                this.setAllDisplaySegments("Aux");
                changeAuxBank (-this.auxBank - 1);
                changeFaderBanks(0);
            }
            else if (newMode == "MarkerMode")
            {
                this.setAllDisplaySegments("Marker");
                changeFaderBanks(0);
                changeMarkerBank(0);
            }
            else if (newMode == "TrackMode")
            {
                this.setAllDisplaySegments(" ");
                changeFaderBanks(0);
            }

            this.onTimer();
        }
        else // go back to track view
        {
            this.assignmentMode = "PanMode"; // to avoid loop
            this.setAssignmentMode("TrackMode");
        }
    }

    this.onTimer = function (name)
    {
        if (name == "auxTimer")
        {
            stopTimer ("auxTimer");

            var auxCopy = this.userMovedAuxes;
            this.userMovedAuxes = new Array();

            for (var i = auxCopy.length; --i >= 0;)
            {
                var chan = auxCopy[i];
                var level = this.auxLevels[chan];
                this.auxLevels[chan] = -1000.0;
                this.onAuxMoved(chan, this.auxBusNames[chan], level);
            }
        }
    }

    this.moveFaderInt = function(dev, channelNum, newSliderPos)
    {       
        var faderPos = clamp(0, 0x3fff, (newSliderPos * 0x3fff));

        this.lastFaderPos[dev][channelNum] = faderPos;

        if (this.assignmentMode == "TrackMode")
            this.setDisplaySegment(dev, channelNum, 1, decibelsToStringWithUnit(volumeFaderPositionToDB(newSliderPos)));

        sendMidiToDevice([(0xe0 + channelNum), (faderPos & 0x7f), (faderPos >> 7)], dev);
    }

    this.onMoveFader = function(channelNum_, newSliderPos)
    {
        var channelNum = Math.floor(channelNum_ % 8);
        var dev        = Math.floor(channelNum_ / 8);

        if (channelNum < 8)
        {
            if (this.flipped)
                this.movePanPotInt(dev, channelNum, newSliderPos * 2.0 - 1.0);
            else
                this.moveFaderInt(dev, channelNum, newSliderPos);
        }
    }

    this.onMasterLevelFaderMoved = function(newLeftSliderPos, newRightSliderPos)
    {
        this.moveFaderInt (this.mcuIdx, 8, (newLeftSliderPos + newRightSliderPos) * 0.5);
    }

    this.movePanPotInt = function(dev, channelNum, newPan)
    {
        this.panPos [dev * 8 + channelNum] = newPan;

        var channel = 0; // mode selected in configurator options
        var newPanValDmy = Math.round(newPan * 63.5 + 63.5);

        if (this.assignmentMode == "PanMode")
        {
            channel = 2;
            this.setDisplaySegment(dev, channelNum, 1, panToString(newPan));
        }
        else if (this.assignmentMode == "PluginMode")
        {
            channel = 2;
        }
        else if (this.assignmentMode == "MarkerMode")
        {
            newPanValDmy = 0;
            channel = 1;
        }
        else // AuxMode
        {
            channel = 1;
        }

        sendMidiToDevice([0xb0 | channel, (0x30 + channelNum), newPanValDmy], dev);      
    }

    this.onPanPotMoved = function(channelNum_, newPan)
    {
        var channelNum = Math.floor(channelNum_ % 8);
        var dev        = Math.floor(channelNum_ / 8);

        if (this.flipped)
            this.moveFaderInt(dev, channelNum, (newPan + 1.0) * 0.5);
        else if (this.assignmentMode == "PanMode")
            this.movePanPotInt(dev, channelNum, newPan);
    }

    this.auxString = function(chan)
    {
        return decibelsToStringWithUnit(volumeFaderPositionToDB(this.auxLevels[chan]));
    }

    this.onAuxMoved = function(channelNum_, bus, newPos)
    {
        var channelNum = Math.floor(channelNum_ % 8);
        var dev        = Math.floor(channelNum_ / 8);

        if ((this.auxLevels[channelNum_] != newPos || bus == this.auxBusNames[channelNum_])
            && channelNum >= 0 && channelNum < 8)
        {
            this.auxLevels[channelNum_] = newPos;
            this.auxBusNames[channelNum_] = bus;

            if (this.assignmentMode == "AuxMode")
            {
                if (this.flipped)
                    this.moveFaderInt(dev, channelNum, newPos);
                else
                    this.movePanPotInt(dev, channelNum, newPos * 2.0 - 1.0);

                if (this.userMovedAuxes.indexOf (channelNum_) != -1)
                    this.setDisplaySegment(dev, channelNum, 1, this.auxString(channelNum_));
                else
                    this.setDisplaySegment(dev, channelNum, 1, String(bus));
            }
        }
    }

    this.onAuxCleared = function(channel_)
    {
        var channel = Math.floor(channel_ % 8);
        var dev     = Math.floor(channel_ / 8);

        if (this.assignmentMode == "AuxMode")
        {
            this.clearDisplaySegment(dev, channel, 1);

            if (this.flipped)
                this.moveFaderInt(dev, channel, 0);
            else
                this.movePanPotInt(dev, channel, 0);
        }
    }

    this.lightUpButton = function(dev, buttonNum, on)
    {
        sendMidiToDevice([0x90, buttonNum, on ? 0x7f : 0], dev);
    }

    this.onSoloMuteChanged = function(channelNum, state, isBright)
    {
        var soloLit         = 1;   // Track is explicitly soloed. 
        var soloFlashing    = 2;   // Track is implicitly soloed. 
        var soloIsolate     = 4;   // Track is explicitly solo isolated. 
        var muteLit         = 8;   // Track is explicitly muted.
        var muteFlashing    = 16;  // Track is implicitly muted.

        this.lightUpButton(Math.floor(channelNum / 8), 0x08 + Math.floor(channelNum % 8), (state & soloLit) != 0 || (isBright && (state & soloFlashing) != 0));
        this.lightUpButton(Math.floor(channelNum / 8), 0x10 + Math.floor(channelNum % 8), (state & muteLit) != 0 || (isBright && (state & muteFlashing) != 0));
    }

    this.onSoloCountChanged = function(anySoloTracks)
    {
        // (rude solo light)
        this.lightUpButton(this.mcuIdx, 0x73, anySoloTracks);
    }

    this.onTrackSelectionChanged = function(channel, isSelected)
    {
        this.lightUpButton(Math.floor(channel / 8), 0x18 + Math.floor(channel % 8), isSelected);
    }

    this.onPlayStateChanged = function(isPlaying)
    {
        this.lightUpButton(this.mcuIdx, 0x5e, isPlaying);
        this.lightUpButton(this.mcuIdx, 0x5d, ! isPlaying);
    }

    this.onRecordStateChanged = function(isRecording)
    {
        this.lightUpButton(this.mcuIdx, 0x5f, isRecording);

        if (isRecording)
            this.lightUpButton(this.mcuIdx, 0x5d, false);
    }

    this.onLoopChanged = function(isLoopOn)
    {
        this.lightUpButton(this.mcuIdx, 0x56, isLoopOn);
    }

    this.onClickChanged = function(isClickOn)
    {
        this.lightUpButton(this.mcuIdx, 0x59, isClickOn);
    }

    this.onParameterChanged = function(parameterNumber_, newValue)
    {
        var parameterNumber = Math.floor(parameterNumber_ % 8);
        var dev             = Math.floor(parameterNumber_ / 8);

        if (this.assignmentMode == "PluginMode")
        {
            this.setDisplaySegment(dev, parameterNumber, 0, newValue.label);
            this.setDisplaySegment(dev, parameterNumber, 1, newValue.valueDescription);

            if (this.flipped)
                this.moveFaderInt(dev, parameterNumber, newValue.value);
            else
                this.movePanPotInt(dev, parameterNumber, newValue.value * 2.0 - 1.0);
        }
    }

    this.onParameterCleared = function(parameterNumber_)
    {
        var parameterNumber = Math.floor(parameterNumber_ % 8);
        var dev             = Math.floor(parameterNumber_ / 8);

        if (this.assignmentMode == "PluginMode")
        {
            this.clearDisplaySegment(dev, parameterNumber, 0);
            this.clearDisplaySegment(dev, parameterNumber, 1);

            if (this.flipped)
                this.moveFaderInt(dev, parameterNumber, 0);
            else
                this.movePanPotInt(dev, parameterNumber, 0);
        }
    }

    this.onFaderBankChanged = function(newStartChannelNumber, trackNames)
    {
        for (var i = 0; i < this.numExtenders + 1; ++i)
        {
            for (var j = 0; j < 8; ++j)
            {
                if (this.assignmentMode == "PluginMode")
                {
                    this.newChannelNos[i][j] = 0;
                    continue;
                }

                this.newChannelNos[i][j] = i * 8 + j + 1 + newStartChannelNumber;                      
            }
        }

        if (this.assignmentMode == "TrackMode" || this.assignmentMode == "PanMode" || this.assignmentMode == "AuxMode" || this.assignmentMode == "MarkerMode")
        {
            for (var i = 0; i < this.numExtenders + 1; ++i)
            {
                this.clearDisplayLine(i, 0);

                for (var j = 0; j < 8; ++j)
                    this.setDisplaySegment(i, j, 0, j + i * 8 < trackNames.length ? trackNames[j + i * 8] : "");
            }

            if (this.assignmentMode == "AuxMode")
            {  
                for (var i = 0; i < this.numExtenders + 1; ++i)
                {
                    this.clearDisplayLine(i, 1);

                    for (var j = 0; j < 8; j++)
                        this.setDisplaySegment(i, j, 1, this.auxString(j + i * 8));
                }
            }
        }
    }

    this.onChannelLevelChanged = function(channelNum_, l, r)
    {
        var channel = Math.floor(channelNum_ % 8);
        var dev     = Math.floor(channelNum_ / 8);

        var newValueR = clamp(0, 13, Math.round(13.0 * r));

        if (this.lastChannelLevelsR[channelNum_] != newValueR)
        {
            this.lastChannelLevelsR[channelNum_] = newValueR;

            var d = zeroedArray(2);
            d[0] = 0xd0;
            d[1] = ((channel << 4) | newValueR);

            sendMidiToDevice(d, dev);
        }

        var newValueL = clamp(0, 13, Math.round(13.0 * l));

        if (this.lastChannelLevelsR[channelNum_] != newValueL)
        {
            this.lastChannelLevelsR[channelNum_] = newValueL;

            var d = zeroedArray(2);
            d[0] = 0xd1;
            d[1] = ((channel << 4) | newValueL);

            sendMidiToDevice(d, dev);
        }
    }

    this.onTrackRecordEnabled = function(channel, isEnabled)
    {
        if (this.recLight[channel] != isEnabled)
        {
            this.recLight[channel] = isEnabled;
            this.lightUpButton(Math.floor(channel / 8), Math.floor(channel % 8), isEnabled);
        }
    }

    this.isShowingPluginParams = function()
    {
        return this.assignmentMode == "PluginMode";
    }

    this.isShowingMarkers = function()
    {
        return this.assignmentMode == "MarkerMode";
    }

    this.isShowingTracks = function()
    {
        return true;
    }

    this.onExtendersChanged = function(num, main)
    {
        this.mcuIdx                 = main;
        this.numExtenders           = num;
        this.numberOfFaderChannels  = 8 * (num + 1);
        this.numParameterControls   = 8 * (num + 1);
        this.numMarkers             = 8 * (num + 1);

        updateDeviceState();
    }

    this.clearAllDisplays = function()
    {
        for (var i = 0; i < this.numExtenders + 1; ++i)
            this.setWholeDisplay(i, "", "", "");
    }

    this.clearDisplayLineAll = function(line)
    {
        for (var i = 0; i < this.numExtenders + 1; ++i)
            this.clearDisplayLine(i, line);
    }

    this.clearDisplayLine = function(devIdx, row)
    {
        var len = this.maxCharsOnDisplayPerLine;

        if (row == 2)
            len = this.maxCharsOnDisplayThird;

        for (var i = 0; i < len; i++)
                this.newDisplayChars[row][devIdx][i] = 0;

        triggerAsyncUpdate();
    }

    this.onMarkerChanged = function(parameterNumber_, newValue)
    {
        var parameterNumber = Math.floor(parameterNumber_ % 8);
        var dev             = Math.floor(parameterNumber_ / 8);

        if (this.assignmentMode == "MarkerMode")
        {
            this.setDisplaySegment(dev, parameterNumber, 1, newValue.number.toString() + ":" + newValue.label);

            if (this.flipped)
                this.moveFaderInt(dev, parameterNumber, 0);
            else
                this.movePanPotInt(dev, parameterNumber, 0);
        }
    }

    this.onMarkerCleared = function(parameterNumber_)
    {
        var parameterNumber = Math.floor(parameterNumber_ % 8);
        var dev             = Math.floor(parameterNumber_ / 8);

        if (this.assignmentMode == "MarkerMode")
        {
            this.clearDisplaySegment(dev, parameterNumber, 1);

            if (this.flipped)
                this.moveFaderInt(dev, parameterNumber, 0);
            else
                this.movePanPotInt(dev, parameterNumber, 0);
        }
    }

    this.onAuxBankChanged = function(bank)
    {
        for (var i = 0; i < this.maxNumChannels; ++i)
            this.auxLevels[i] = -1000.0;

        stopTimer("auxTimer");
        this.auxBusNames = zeroed2DArray(this.maxNumChannels, this.maxCharsOnDisplayPerDisplay);
        
        this.userMovedAuxes = new Array();

        this.auxBank = bank;
    }

}

registerController (new AsparionD700());